#!/bin/bash
if [ -d /home/pi/.xbmc ]; then 
  rm -rf /home/pi/.xbmc
  rm /home/pi/.xbmc-current
fi
ROOT_DEV="/dev/mmcblk0"
MESSAGE="Please wait a minute while SD Card is resized\n\nStep 2 of 2"
for line in `cat /proc/cmdline`; do
  root=$(echo $line | grep "root=" | sed -e "s/root=//")
  if [ "x$root" != "x" ]; then
    SD=$(echo $root | grep mmcblk)
    if [ "x$SD" == "x" ]; then
       ROOT_DEV=$(echo $root | sed -e 's/[0-9]$//')
       MESSAGE="Please wait a minute while USB Disk is resized\n\nStep 2 of 2"
    fi
  fi
done
dialog --title "Raspbmc Installer" --infobox "$MESSAGE" 5 50

if [ "$ROOT_DEV" == "/dev/mmcblk0" ]; then
logger -t run_once "resize partition "${ROOT_DEV}2
resize2fs ${ROOT_DEV}p2 >/dev/null 2>&1
fi
mv /etc/init/xbmc.conf.bk /etc/init/xbmc.conf
mv /etc/init/update-checker.conf.bk /etc/init/update-checker.conf
rm /runonce.sh
